# Basic string examples using single and double quotes
print('I am a string.')
print("I am also a string.")

# Mixing quotes inside strings
print('She said "Python is awesome."')  # Double quotes inside single quotes
print("He also said, Python's awesome.")  # Apostrophe inside double quotes

# String case formatting
name = "john doe"
print(name.title())   # Capitalizes each word: John Doe
print(name.upper())   # Converts to uppercase: JOHN DOE
print(name.lower())   # Converts to lowercase: john doe

# Using f-strings to combine variables into a full name
first_name = "john"
last_name = "doe"
full_name = f"{first_name} {last_name}"
print(f"Hello, {full_name.title()}!")  # Prints: Hello, John Doe!

# Storing the message in a variable and printing it
message = f"Hello, {full_name.title()}!"
print(message)

# Combining strings using the + operator
first_name = "John"
last_name = "Doe"
full_name = first_name + " " + last_name
print("Hello, " + full_name + "!")  # Prints: Hello, John Doe!

# Measuring string length
name = "John Doe"
print(len(name))  # Output: 8 (includes space)

# Accessing characters by index
name = "John Doe"
print(name[0])       # First character: J
print(name[-1])      # Last character: e
print(name[5:8])     # Slice: characters 5 to 7 → Doe

# Using escape characters for formatting
print("Languages:\n\tPython\n\tC\n\tJavaScript")  # Newlines and tabs

# Removing whitespace from strings
language = " All About Python "
print(language.rstrip())  # Removes trailing spaces
print(language.lstrip())  # Removes leading spaces
print(language.strip())   # Removes both leading and trailing spaces

# Updating the variable to store the stripped version
language = language.strip()  # Permanently remove whitespace

# Removing a prefix from a string (Python 3.9+)
url = "https://allaboutpython.co.uk"
clean_url = url.removeprefix("https://")
print(clean_url)  # Prints: allaboutpython.co.uk

# Customizing separators between printed items
print("Python", "JavaScript", "C", sep=", ")  # Output: Python, JavaScript, C

# Customizing the end of a print statement
print("Hello", end=" ")  # Ends with a space instead of newline
print("World!")          # Continues on the same line

# Demonstrating string vs numeric operations
print(1 + 1)             # Numeric addition: 2
print("1" + "1")         # String concatenation: "11"
print(1 + int("1"))      # Convert string to int: 2

# print(1 + "1")         # ❌ TypeError: mixing int and string (commented out)

# Single-line comment example
# I am a single line comment

# Multi-line string (can act as a comment if unused)
'''I am
a multi line
comment, I can also be a string'''

"""I am also a 
multi line 
comment I can also be a string """

# Multi-line string used as actual output
print('''I am
a multi line
comment, I can also be a string''')

print("""I am also a 
multi line 
comment I can also be a string """)
