# 🔍 Use type() to check the data type of any value
print(type(42))        # <class 'int'> → Integer: whole number
print(type("42"))      # <class 'str'> → String: text in quotes
print(type(3.14))      # <class 'float'> → Float: decimal number
print(type(True))      # <class 'bool'> → Boolean: True or False

# 🔢 Integers (int): whole numbers, no decimal
print(type(-7))        # Negative integer
print(type(0))         # Zero is also an integer
print(type(999999))    # Large positive integer

# 🌊 Floats (float): numbers with decimal points
print(type(3.14))      # Common float
print(type(-0.001))    # Negative float
print(type(2.0))       # Float even though it looks like a whole number

# ✅ Booleans (bool): logical values
print(type(True))      # Boolean True
print(type(False))     # Boolean False

# 📝 Strings (str): text inside quotes
print(type("Hello"))   # Regular string
print(type("42"))      # Looks like a number, but it's a string

# 🔄 Converting between types
print(int("42"))       # Converts string to integer
print(float("3.14"))   # Converts string to float
print(str(100))        # Converts integer to string
print(bool(1))         # Converts to True
print(bool(0))         # Converts to False

# ⚠️ Common Pitfalls
# Mixing types without converting
# print("Age: " + 25)   # ❌ TypeError: can't add str and int
print("Age: " + str(25))  # ✅ Convert int to str before combining

# Division confusion
print(7 / 2)           # 3.5 → float division
print(7 // 2)          # 3 → integer division

# Modulo with negatives
print(-7 % 3)          # 2 → Python keeps remainder positive

# 🧮 Precision Errors with Floats
print(0.1 + 0.2)       # 0.30000000000000004 → floating-point error

# ✅ Use decimal for exact math
from decimal import Decimal
print(Decimal("0.1") + Decimal("0.2"))  # 0.3 → exact result

# 🧠 Real-World Use Cases
# Integers: loop counters, indexing, scores
# Floats: measurements, currency, scientific data
# Booleans: conditions, logic, flags
# Strings: user input, messages, labels

# 🧪 Input Handling
age = input("Enter your age: ")
print(type(age))       # Always returns <class 'str'>
age = int(age)         # Convert to integer if needed

# 🔢 Python follows BODMAS (also called PEMDAS) to evaluate expressions:
# Brackets → Orders (Exponents) → Division → Multiplication → Addition → Subtraction

# ✅ Parentheses first
print((2 + 3) * 4)     # 5 * 4 = 20

# ✅ Exponents before addition
print(2 + 3 ** 2)      # 3**2 = 9 → 2 + 9 = 11

# ✅ Multiplication before addition
print(2 + 3 * 4)       # 3 * 4 = 12 → 2 + 12 = 14

# ✅ Division before subtraction
print(10 - 4 / 2 + 6)  # 4 / 2 = 2 → 10 - 2 + 6 = 14

# ✅ Use parentheses to control the order
print(10 - (4 / (2 + 2)))  # 2 + 2 = 4 → 4 / 4 = 1 → 10 - 1 = 9
