# --------------------------------------------------
# 🐍 Ultimate Python Variables Cheat Sheet (Beginner to Advanced)
# --------------------------------------------------

# 📘 PART 1: Crack Python Basics — Learn Variables the Easy Way

# ▶️ Using Variables
message = "Hello world!" #assigning a value to the variable message
print(message)

message = "Hello All About Python world!" # changing the value of the variable called message
print(message)

# ▶️ Naming Rules
user_name = "Alice"     # ✅ Valid
total_score = 42        # ✅ Valid
_valid = True           # ✅ Starts with underscore

# ❌ Invalid Examples
# 1st_place = "Gold"    # Starts with number
# user name = "Bob"     # Contains space
# class = "Math"        # Python keyword

# ▶️ Common Mistake: NameError
# print(mesage)         # Misspelled variable name → NameError

# ▶️ Variables Are Labels, Not Boxes
# Think of variables as labels pointing to values—not containers.

# --------------------------------------------------
# 📘 PART 2: Python Variables Continued — Assignments, Globals & Naming Styles
# --------------------------------------------------

# 🎯 Assigning Multiple Values
x, y, z = 1, 2, 3       # Assign multiple values at once
a = b = c = 0           # Assign same value to multiple variables

# 🌍 Global Variables
counter = 0             # Global variable

def increment():
    global counter      # Declare global inside function
    counter += 1

# ⚖️ Pros and Cons of Global Variables
# Pros:
# - Accessible from anywhere
# - Useful for shared settings
# - Simplifies small scripts
# - Quick to implement

# Cons:
# - Harder to debug
# - Risk of accidental changes
# - Reduces modularity
# - Name conflicts
# - Can lead to messy code

# 🧩 Naming Styles for Multi-Word Variables
PascalCase = "Used for class names"
snake_case = "Preferred for variables and functions in Python"
camelCase = "Common in other languages like JavaScript"

# 📜 Variable Naming Rules Recap
_valid_name = True      # ✅ Starts with letter or underscore
# 2invalid = False      # ❌ Invalid: starts with number
caseSensitive = "Python is case-sensitive"
# class = "reserved"    # ❌ Invalid: 'class' is a Python keyword

import keyword
print("Python keywords:", keyword.kwlist) # lists all available keywords

# 📦 Unpacking Lists
colors = ["red", "green", "blue"]
r, g, b = colors        # Unpack into variables

first, *middle, last = [1, 2, 3, 4, 5]
# first = 1, middle = [2, 3, 4], last = 5

# 🔒 Constants in Python (by convention)
MAX_RETRIES = 5
API_URL = "https://example.com"
PI = 3.14159

# ⚠️ Python won't enforce constants—treat them with care
MAX_RETRIES = 10  # Allowed, but not recommended

# ✍️ Best Practices for Constants
# - Use ALL CAPS
# - Define at top of script or config file
# - Only use for values that shouldn't change
# - Don't overuse—keep code clean and focused

# --------------------------------------------------
# 🚀 Ready to Practice?
# Create a file called variables.py and start experimenting.
# Change values, make mistakes, and learn from them.