# Python Lists for Beginners: Code Examples

# --- Creating Lists ---
fruits = ['apple', 'banana', 'cherry']
mixed = [42, 'hello', 3.14]
print(fruits)
print(mixed)

# --- Accessing List Elements ---
print(fruits[0])       # 'apple'
print(fruits[-1])      # 'cherry'
print(len(fruits))     # 3

# --- Using Individual Values ---
message = f"I love {fruits[1]}!"
print(message)

# --- Modifying Elements ---
fruits[1] = 'blueberry'
print(fruits)

# --- Adding Elements ---
fruits.append('date')
fruits.insert(1, 'kiwi')
# print(fruits)

# --- Removing Elements ---
del fruits[0]
last_item = fruits.pop()
middle_item = fruits.pop(1)
fruits.remove('cherry')
print(last_item)
print(middle_item)
print(fruits)

# --- Organizing a List ---
print(sorted(fruits))          # Sort temporarily
print(fruits)
fruits.sort()                  # Sort permanently
print(fruits)
fruits.reverse()               # Reverse order
print(fruits)

# --- Finding Length ---
print(len(fruits))

# --- Avoiding Index Errors ---
if len(fruits) > 2:
    print(fruits[2])

# --- Looping Through a List ---
for fruit in fruits:
    print(fruit)

# --- List Comprehension ---
squares = [x**2 for x in range(5)]
print(squares)

# --- Copying Lists ---
new_list = fruits.copy()
print(new_list)

# --- Joining Lists ---
combined = fruits + ['grape', 'melon']
print(combined)

# --- Using range() ---
for number in range(1, 5):
    print(number)

for number in range(1, 6):
    print(number)

# --- Creating Lists with range() ---
numbers = list(range(1, 6))
print(numbers)

# --- Skipping Numbers with Step Values ---
evens = list(range(2, 11, 2))
print(evens)

odds = list(range(1, 10, 2))
print(odds)

# --- Building a List of Squares (long way) ---
squares = []
for number in range(1, 11):
    square = number ** 2
    squares.append(square)
print(squares)

# --- Building a List of Squares (short way) ---
squares = [number**2 for number in range(1, 11)]
print(squares)

# --- Simple Stats with Lists ---
digits = [1, 2, 3, 4, 5, 6, 7, 8, 9, 0]
print(min(digits))  # 0
print(max(digits))  # 9
print(sum(digits))  # 45

# --- Slicing Lists ---
players = ['charles', 'martina', 'michael', 'florence', 'eli']
print(players[0:3])

# --- Looping Through a Slice ---
for player in players[:3]:
    print(player)

# --- Copying a List with Slicing ---
copy1 = players[:]
copy2 = players.copy()
print(copy1)
print(copy2)

# --- Tuples in Python ---
dimensions = (1920, 1080)
print(dimensions[0])

for dimension in dimensions:
    print(dimension)

# --- Rewriting a Tuple ---
dimensions = (1280, 720)
print(dimensions)